/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 3.0 Edition
 BSD License, Use at your own risk
 */

#import "UIView-SubviewGeometry.h"
static BOOL seeded = NO;

// To jest prywatna wersja funkcji dostępnej w kategorii UIView Frame.
// Została dołączona jako funkcja prywatna, aby uniknąć wymogu dołączania innych plików.
CGRect rectWithCenter(CGRect rect, CGPoint center)
{
	CGRect newrect = CGRectZero;
	newrect.origin.x = center.x-CGRectGetMidX(rect);
	newrect.origin.y = center.y-CGRectGetMidY(rect);
	newrect.size = rect.size;
	return newrect;
}

@implementation UIView (SubviewGeometry)
#pragma mark Bounded Placement
- (BOOL) canMoveToCenter: (CGPoint) aCenter inView: (UIView *) aView withInsets: (UIEdgeInsets) insets
{
	CGRect container = UIEdgeInsetsInsetRect(aView.bounds, insets);
	return CGRectContainsRect(container, rectWithCenter(self.frame, aCenter));
}

- (BOOL) canMoveToCenter: (CGPoint) aCenter inView: (UIView *) aView withInset: (float) inset
{
	UIEdgeInsets insets = UIEdgeInsetsMake(inset, inset, inset, inset);
	return [self canMoveToCenter:aCenter inView:aView withInsets:insets];
}

- (BOOL) canMoveToCenter: (CGPoint) aCenter inView: (UIView *) aView
{
	return [self canMoveToCenter:aCenter inView:aView withInset:0];
}

#pragma mark Obsługa procentów
// Przesunięcie widoku w odpowiednie miejsce na podstawie podanych wartości procentowych.
- (CGPoint) centerInView: (UIView *) aView withHorizontalPercent: (float) h withVerticalPercent: (float) v
{
	// Przesunięcie o podaną wartość, a następnie wielkość podwidoku.
	CGRect baseRect = aView.bounds;
	CGRect subRect = CGRectInset(baseRect, self.frame.size.width / 2.0f, self.frame.size.height / 2.0f);
	
	// Zwrot punktu znajdującego się na wysokości h% poziomo i v% pionowo.
	float px = (float)(h * subRect.size.width);
	float py = (float)(v * subRect.size.height);
	return CGPointMake(px + subRect.origin.x, py + subRect.origin.y);
}

- (CGPoint) centerInSuperviewWithHorizontalPercent: (float) h withVerticalPercent: (float) v
{
	return [self centerInView:self.superview withHorizontalPercent:h withVerticalPercent:v];
}

#pragma mark Losowo wybrany punkt
// Podziękowania dla Augusta Joki and manitoba98
- (CGPoint) randomCenterInView: (UIView *) aView withInsets: (UIEdgeInsets) insets
{
    // Losowo wybrana wartość.
    if (!seeded) {seeded = YES; srandom(time(NULL));}
    
	// Przesunięcie o podaną wartość, a następnie wielkość podwidoku.
	CGRect innerRect = UIEdgeInsetsInsetRect([aView bounds], insets);
	CGRect subRect = CGRectInset(innerRect, self.frame.size.width / 2.0f, self.frame.size.height / 2.0f);
	
	// Zwrot losowo wygenerowanego punktu.
	float rx = (float)(random() % (int)floor(subRect.size.width));
	float ry = (float)(random() % (int)floor(subRect.size.height));
	return CGPointMake(rx + subRect.origin.x, ry + subRect.origin.y);
}

- (CGPoint) randomCenterInView: (UIView *) aView withInset: (float) inset
{
	UIEdgeInsets insets = UIEdgeInsetsMake(inset, inset, inset, inset);
	return [self randomCenterInView:aView withInsets:insets];
}

- (void) moveToRandomLocationInView: (UIView *) aView animated: (BOOL) animated
{
	if (!animated)
	{
		self.center = [self randomCenterInView:aView withInset:5];
		return;
	}
	
    [UIView animateWithDuration:0.3f animations:^(void){
         self.center = [self randomCenterInView:aView withInset:5];}];
}

- (void) moveToRandomLocationInSuperviewAnimated: (BOOL) animated
{
	[self moveToRandomLocationInView:self.superview animated:animated];
}

@end

